/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api;

import fuzs.armorstatues.api.network.client.C2SArmorStandNameMessage;
import fuzs.armorstatues.api.network.client.C2SArmorStandPoseMessage;
import fuzs.armorstatues.api.network.client.C2SArmorStandPositionMessage;
import fuzs.armorstatues.api.network.client.C2SArmorStandRotationMessage;
import fuzs.armorstatues.api.network.client.C2SArmorStandStyleMessage;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandStyleOption;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandStyleOptions;
import fuzs.puzzleslib.core.CoreServices;
import fuzs.puzzleslib.core.ModConstructor;
import fuzs.puzzleslib.network.MessageDirection;
import fuzs.puzzleslib.network.NetworkHandler;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatuesApi
implements ModConstructor {
    public static final String MOD_ID = "statues";
    public static final String MOD_NAME = "Statues";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Statues");
    public static final NetworkHandler NETWORK = CoreServices.FACTORIES.network("statues", true, true);

    public void onConstructMod() {
        StatuesApi.registerMessages();
    }

    private static void registerMessages() {
        NETWORK.register(C2SArmorStandNameMessage.class, C2SArmorStandNameMessage::new, MessageDirection.TO_SERVER);
        NETWORK.register(C2SArmorStandStyleMessage.class, C2SArmorStandStyleMessage::new, MessageDirection.TO_SERVER);
        NETWORK.register(C2SArmorStandPositionMessage.class, C2SArmorStandPositionMessage::new, MessageDirection.TO_SERVER);
        NETWORK.register(C2SArmorStandPoseMessage.class, C2SArmorStandPoseMessage::new, MessageDirection.TO_SERVER);
        NETWORK.register(C2SArmorStandRotationMessage.class, C2SArmorStandRotationMessage::new, MessageDirection.TO_SERVER);
    }

    public void onCommonSetup() {
        for (ArmorStandStyleOptions styleOption : ArmorStandStyleOptions.values()) {
            ArmorStandStyleOption.register(StatuesApi.id(styleOption.getName().toLowerCase(Locale.ROOT)), styleOption);
        }
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

